--[[
Lua rings by londonali1010 (2011) - Edited by Etles_Team (2016)
To use this script in conky, Following this command before (TEXT) in conkyrc file, Example :
lua_load ~/.conky/CONKY-NAME/scripts/lua/rings.lua
lua_draw_hook_pre clock_rings

]]

settings_table = {
   {
      name='time',
      arg='%S',
      max=60,
      bg_colour=0x778899,
      bg_alpha=0.4,
      fg_colour=0xff6e6e,
      fg_alpha=0.8,
      x=150, y=99,
      radius=60,
      thickness=10,
      start_angle=-90,
      end_angle=90
   },

   {
      name='time',
      arg='%I',
      max=12,
      bg_colour=0x778899,
      bg_alpha=0.4,
      fg_colour=0x4cdd9f,
      fg_alpha=0.8,
      x=90, y=130,
      radius=25,
      thickness=10,
      start_angle=0,
      end_angle=360
   },
   {--ring bg
      name='time',
      arg='%u',
      max=12,
      bg_colour=0x778899,
      bg_alpha=0.4,
      fg_colour=0xffffff,
      fg_alpha=0,
      x=90, y=130,
      radius=8,
      thickness=22,
      start_angle=0,
      end_angle=360
   },

   {
      name='time',
      arg='%M',
      max=60,
      bg_colour=0x778899,
      bg_alpha=0.4,
      fg_colour=0x71bd36,
      fg_alpha=0.8,
      x=210, y=130,
      radius=25,
      thickness=10,
      start_angle=0,
      end_angle=360
   },
   {--ring bg
      name='time',
      arg='%u',
      max=60,
      bg_colour=0x778899,
      bg_alpha=0.4,
      fg_colour=0xffffff,
      fg_alpha=0,
      x=210, y=130,
      radius=8,
      thickness=22,
      start_angle=0,
      end_angle=360
   },

   {
      name='time',
      arg='%S',
      max=60,
      bg_colour=0x778899,
      bg_alpha=0.6,
      fg_colour=0xff6e6e,
      fg_alpha=0.8,
      x=150, y=161,
      radius=60,
      thickness=10,
      start_angle=-270,
      end_angle=-90
   },

   {
      name='cpu',
      arg='cpu1',
      max=80,
      bg_colour=0x778899,
      bg_alpha=0.4,
      fg_colour=0xe3ae4a,
      fg_alpha=0.8,
      x=150, y=90,
      radius=25,
      thickness=10,
      start_angle=0,
      end_angle=360
   },
   {
      name='time',
      arg='%u',
      max=60,
      bg_colour=0x778899,
      bg_alpha=0.4,
      fg_colour=0xffffff,
      fg_alpha=0,
      x=150, y=90,
      radius=8,
      thickness=22,
      start_angle=0,
      end_angle=360
   },

   {
      name='freq',
      arg='cpu',
      max=2100,
      bg_colour=0x778899,
      bg_alpha=0.6,
      fg_colour=0x6f83e7,
      fg_alpha=0.8,
      x=150, y=170,
      radius=25,
      thickness=10,
      start_angle=0,
      end_angle=360
   },
   {--ring bg
      name='time',
      arg='%u',
      max=2100,
      bg_colour=0x778899,
      bg_alpha=0.4,
      fg_colour=0xffffff,
      fg_alpha=0,
      x=150, y=170,
      radius=8,
      thickness=22,
      start_angle=0,
      end_angle=360
   },

}

require 'cairo'

function rgb_to_r_g_b(colour,alpha)
    return ((colour / 0x10000) % 0x100) / 255., ((colour / 0x100) % 0x100) / 255., (colour % 0x100) / 255., alpha
end

function draw_ring(cr,t,pt)
    local w,h=conky_window.width,conky_window.height
   
    local xc,yc,ring_r,ring_w,sa,ea=pt['x'],pt['y'],pt['radius'],pt['thickness'],pt['start_angle'],pt['end_angle']
    local bgc, bga, fgc, fga=pt['bg_colour'], pt['bg_alpha'], pt['fg_colour'], pt['fg_alpha']

    local angle_0=sa*(2*math.pi/360)-math.pi/2
    local angle_f=ea*(2*math.pi/360)-math.pi/2
    local t_arc=t*(angle_f-angle_0)

    -- Draw background ring

    cairo_arc(cr,xc,yc,ring_r,angle_0,angle_f)
    cairo_set_source_rgba(cr,rgb_to_r_g_b(bgc,bga))
    cairo_set_line_width(cr,ring_w)
    cairo_stroke(cr)
   
    -- Draw indicator ring

    cairo_arc(cr,xc,yc,ring_r,angle_0,angle_0+t_arc)
    cairo_set_source_rgba(cr,rgb_to_r_g_b(fgc,fga))
    cairo_stroke(cr)       
end

function conky_clock_rings()
    local function setup_rings(cr,pt)
        local str=''
        local value=0
       
        str=string.format('${%s %s}',pt['name'],pt['arg'])
        str=conky_parse(str)
       
        value=tonumber(str)
        pct=value/pt['max']
       
        draw_ring(cr,pct,pt)
    end
   
    -- Check that Conky has been running for at least 5s

    if conky_window==nil then return end
    local cs=cairo_xlib_surface_create(conky_window.display,conky_window.drawable,conky_window.visual, conky_window.width,conky_window.height)
   
    local cr=cairo_create(cs)   
   
    local updates=conky_parse('${updates}')
    update_num=tonumber(updates)
   
    if update_num>1 then
        for i in pairs(settings_table) do
            setup_rings(cr,settings_table[i])
        end
    end
end
--=================================== Regards, Etles_Team ==========================================--