document.addEventListener('DOMContentLoaded', function() {

  document.getElementsByTagName('form')[0].onsubmit = function(evt) {
    evt.preventDefault(); // Preventing the form from submitting
    checkWord(); // Do your magic and check the entered word/sentence
    window.scrollTo(0,150);
  }

  // Get the focus to the text input to enter a word right away.
  document.getElementById('terminalTextInput').focus();

  // Getting the text from the input
  var textInputValue = document.getElementById('terminalTextInput').value.trim();

  //Getting the text from the results div
  var textResultsValue = document.getElementById('terminalReslutsCont').innerHTML;

  // Clear text input
  var clearInput = function(){
    document.getElementById('terminalTextInput').value = "";
  }

  // Scrtoll to the bottom of the results div
  var scrollToBottomOfResults = function(){
    var terminalResultsDiv = document.getElementById('terminalReslutsCont');
    terminalResultsDiv.scrollTop = terminalResultsDiv.scrollHeight;
  }

  // Scroll to the bottom of the results
  scrollToBottomOfResults();

  // Add text to the results div
  var addTextToResults = function(textToAdd){
    document.getElementById('terminalReslutsCont').innerHTML += "<p>" + textToAdd + "</p>";
    scrollToBottomOfResults();
  }

  // Getting the list of keywords for help & posting it to the screen
  var postHelpList = function(){
    // Array of all the help keywords
    var helpKeyWords = [
      "- ouvrir + URL du site (ex. ouvrir debianfacile.org)",
      "- duckduckgo + mot-clé recherche directement avec duckduckgo (ex. duckduckgo web development)",
      "- youTube + mot-clé recherche directement avec YouTube (ex. youtube miles davis)",
      "- wiki + mot-clé recherche directement avec wiki (ex. wiki brocéliande)",
      "- 'heure' montre l'heure actuelle.",
      "- 'date' montre la date actuelle.",
      "- 'w3' fera de toi un expert du web",
      "* il y a plus de mots-clés à découvrir et des milliards à rajouter..."
    ].join('<br>');
    addTextToResults(helpKeyWords);
  }

  // Getting the time and date and post it depending on what you request for
  var getTimeAndDate = function(postTimeDay){
    var timeAndDate = new Date();
    var timeHours = timeAndDate.getHours();
    var timeMinutes = timeAndDate.getMinutes();
    var dateDay = timeAndDate.getDate();
    console.log(dateDay);
    var dateMonth = timeAndDate.getMonth() + 1; // Because JS starts counting months from 0
    var dateYear = timeAndDate.getFullYear(); // Otherwise we'll get the count like 98,99,100,101...etc.

    if (timeHours < 10){ // if 1 number display 0 before it.
      timeHours = "0" + timeHours;
    }

    if (timeMinutes < 10){ // if 1 number display 0 before it.
      timeMinutes = "0" + timeMinutes;
    }

    var currentTime = timeHours + ":" + timeMinutes;
    var currentDate = dateDay + "/" + dateMonth + "/" + dateYear;

    if (postTimeDay == "time"){
      addTextToResults(currentTime);
    }
    if (postTimeDay == "date"){
      addTextToResults(currentDate);
    }
  }

  // Opening links in a new window
  var openLinkInNewWindow = function(linkToOpen){
    window.open(linkToOpen, '_blank');
    clearInput();
  }

  // Having a specific text reply to specific strings
  var textReplies = function() {
    switch(textInputValueLowerCase){
      // replies

      case "je t'aime":
      case "je t'adore":
      case "love":
        clearInput();
        addTextToResults("Aww! Je t'aime aussi ❤ !");
        break;

      case "w3 school":
      case "w3":
        clearInput();
        addTextToResults('tutos développement web !');
        openLinkInNewWindow('https://www.w3schools.com/');
        break;

      case "bonjour":
      case "salut":
      case "ola":
        clearInput();
        addTextToResults("Bonjour, je suis ton assistant perso... Je suis basé sur JavaScript :).");
        break;

      case "ça va":
      case "ça va ?":
      case "comment vas tu ?":
      case "comment vas tu":
        clearInput();
        addTextToResults("Je vais bien merci ❤ !");
        break;

      case "what the":
      case "wtf":
        clearInput();
        addTextToResults("F***.");
        break;

      case "merde":
      case "m...":
      case "💩":
        clearInput();
        addTextToResults("💩");
        break;

      // replies 

      case "youtube":
        clearInput();
        addTextToResults("Type youtube + something to search for.");
        break;

      case "duckduckgo":
        clearInput();
        addTextToResults("Type duckduckgo + something to search for.");
        break;

        case "wiki":
        case "wikipedia":
          clearInput();
          addTextToResults("Type wiki + something to search for.");
          break;  

      case "heure":
        clearInput();
        getTimeAndDate("time");
        break;

      case "date":
        clearInput();
        getTimeAndDate("date");
        break;

      case "aide":
      case "?":
        clearInput();
        postHelpList();
        break;

      default:
      clearInput();
      addTextToResults("<p><i>La commande " + "<b>" + textInputValue + "</b>" + " n'a pas été trouvée. Tapes <b>aide</b> pour voir toutes les commandes.</i></p>");
      break;
    }
  }

// Main function to check the entered text and assign it to the correct function
  var checkWord = function() {
    textInputValue = document.getElementById('terminalTextInput').value.trim(); //get the text from the text input to a variable
    textInputValueLowerCase = textInputValue.toLowerCase(); //get the lower case of the string

    if (textInputValue != ""){ //checking if text was entered
      addTextToResults("<p class='userEnteredText'>> " + textInputValue + "</p>");
      if (textInputValueLowerCase.substr(0,7) == "ouvrir ") { //if the first 7 characters = open + space
        openLinkInNewWindow('http://' + textInputValueLowerCase.substr(7));
        addTextToResults("<i>L'URL " + "<b>" + textInputValue.substr(7) + "</b>" + " devrait être ouverte maintenant :).</i>");
      } else if (textInputValueLowerCase.substr(0,8) == "youtube ") {
        openLinkInNewWindow('https://www.youtube.com/results?search_query=' + textInputValueLowerCase.substr(8));
        addTextToResults("<i>J'ai cherché sur YouTube pour " + "<b>" + textInputValue.substr(8) + "</b>" + " cela devrait être ouvert maintenant :).</i>");
      } else if (textInputValueLowerCase.substr(0,11) == "duckduckgo ") {
        openLinkInNewWindow('https://duckduckgo.com/?q=' + textInputValueLowerCase.substr(11));
        addTextToResults("<i>J'ai cherché sur duckduckgo pour " + "<b>" + textInputValue.substr(11) + "</b>" + " cela devrait être ouvert maintenant :).</i>");
      } else if (textInputValueLowerCase.substr(0,5) == "wiki "){
        openLinkInNewWindow('https://fr.wikipedia.org/wiki/index.php?search=' + textInputValueLowerCase.substr(5));
        addTextToResults("<i>J'ai cherché sur Wikipedia pour " + "<b>" + textInputValue.substr(5) + "</b>" + " cela devrait être ouvert maintenant :).</i>");
      } else{
        textReplies();
      }
    }
  };

});