-----------------------------------------------------------
-- conky lua script.
-- author: nayk <nayk@nxt.ru>
-- date: 2014
-- license: free open source
-- farouchement retravaillé pour résolution 1600 (original 1950), astiqué débuggé et mis à jour (codes pas propres) toulibre 29//11/2020
------------------------------------------------------------

-- changez la variable pour la couleur souhaitée: ---------------------------------

-- config variant:
-- 1 - blue
-- 2 - orange
conf_num = 2

-----------------------------------------------------------
-- dossier images:
folder = { "blue", "orange" }
-- colors:
color0 = { 'ffffff', 'ffffff' }
color1 = { 'dddddd', 'dddddd' }
color2 = { '72dcff', 'f78b76' }
color3 = { '3dcfff', 'ff7459' }

-- fonts:
font0 = 'Droid Sans:size=6'
font1 = 'Droid Sans:size=6'

-- interface de connexion:
net_dev = 'enp3s0'
-- maximum downspeed:
max_down_speed = 1024
-- conky commands for temperature:
cpu_temp = '${hwmon 1 temp 1}'
mb_temp  = '${hwmon 0 temp 1}'
gpu_temp = '${hwmon 2 temp 2} ' 
hdd_temp = '${hddtemp /dev/sda}' 
-- this var automatic update on start:
distrib_name = 'Unknown'
distrib_ver = 'N/A'
cpu_name = 'Unknown'
cpu_freq = 'N/A'
-- mount filesystem:
mnt_point = {
  '/',
  '/'
}
-- this var automatic update on start:
dev = {
  '/dev/sda',
  '/dev/sda'
}
-- headers (center circles):
headers = {
  { x=236, txt='CPU' },
  { x=441, txt='RAM' },
  { x=645, txt='Temp' },
  { x=862, txt='/' },
  { x=1055, txt='/' },
  { x=1264, txt='NET' }
}

-----------------------------------------------------------
-- functions:
function fTrim(s)
  return string.match(s, "^%s*(.-)%s*$")
end
-----------------------------------------------------------
function fToKB(s)
  if (s == nil) or (string.len(s) < 2) then return 0 end
  if string.sub(s, -1) == "B" then return tonumber(string.sub(s, 1, string.len(s)-1))/1024 end
  if string.sub(s, -1) == "K" then return tonumber(string.sub(s, 1, string.len(s)-1)) end
  if string.sub(s, -1) == "M" then return tonumber(string.sub(s, 1, string.len(s)-1))*1024 end
  if string.sub(s, -1) == "G" then return tonumber(string.sub(s, 1, string.len(s)-1))*1024*1024 end
  return 0
end
-----------------------------------------------------------
function fGetWord(str, num)
  local i=0
  
  for w in string.gmatch(str, " ") do
      i=i+1
      if i == tonumber(num) then return fTrim(w) end       
  end
  return ""
end
-----------------------------------------------------------
-- background:
function conky_background()  
  local str =  "${image /home/toulibre/Téléchargements/conky/" .. folder[conf_num] .. "/bg-0.png -p 0,0 -s 206x78 -f 1200}"
  str = str .. "${image /home/toulibre/Téléchargements/conky/" .. folder[conf_num] .. "/bg-1.png -p 206,0 -s 206x78 -f 1200}"
  str = str .. "${image /home/toulibre/Téléchargements/conky/" .. folder[conf_num] .. "/bg-1.png -p 412,0 -s 206x78 -f 1200}"
  str = str .. "${image /home/toulibre/Téléchargements/conky/" .. folder[conf_num] .. "/bg-1.png -p 618,0 -s 206x78 -f 1200}"
  str = str .. "${image /home/toulibre/Téléchargements/conky/" .. folder[conf_num] .. "/bg-2.png -p 824,0 -s 206x78 -f 1200}"
  str = str .. "${image /home/toulibre/Téléchargements/conky/" .. folder[conf_num] .. "/bg-2.png -p 1030,0 -s 206x78 -f 1200}"
  str = str .. "${image /home/toulibre/Téléchargements/conky/" .. folder[conf_num] .. "/bg-2.png -p 1236,0 -s 206x78 -f 1200}"
  return str 
end
-----------------------------------------------------------
-- diagrams:
function conky_circles()
  local data = {
    '${cpu cpu0}',
    '${memperc}',
    cpu_temp,
    '${fs_used_perc ' .. mnt_point[1] .. '}',
    '${fs_used_perc ' .. mnt_point[2] .. '}',
    '${downspeed ' .. net_dev .. '}'
  }

  local x = 0
  local y = 14
  local str = ''

  for i = 1,6 do
    x = 219 + ( i - 1)*206
    
    local n = conky_parse(data[i])
    if n == nil then n = '0' end
    
    if i == 6 then
      n = fToKB(fTrim(n)) * (100 / max_down_speed)    
    else
      n = tonumber(fTrim(n))
    end
      
    if n == nil then n = 0 end  
    n = math.ceil(0.6 * n)
    if n > 60 then n = 60 end
    
    str = str .. '${image /home/toulibre/Téléchargements/conky/' .. folder[conf_num] .. '/' .. n .. '.png -p ' .. x ..',' .. y .. ' -s 50x50 }'
    
  end

  return str  
end
-----------------------------------------------------------
-- text:
function conky_text()
  
  if distrib_name == 'Unknown' then conky_first() end
  
  local x = { 37, 124, 302, 368, 508, 571, 714, 778, 920, 980, 1126, 1186, 1332, 1392, 1538, 1598, 1744, 1800 }
  local io_x = { 905, 1111, 1317, 1523, 1729}

  local str = "${voffset 13}"
  
  str = str .. "${goto "..x[1].."}${font "..font0.."}${color "..color1[conf_num].."}".. distrib_name ..":"
  str = str .. "${goto "..x[2].."}${color "..color2[conf_num].."}".. distrib_ver
  
  str = str .. "${goto "..x[3].."}${color "..color1[conf_num].."}CPU Coeur 1:"
  str = str .. "${goto "..x[4].."}${color "..color2[conf_num].."}${cpu cpu1}%"
  
  str = str .. "${goto "..x[5].."}${color "..color1[conf_num].."}RAM Total:"
  str = str .. "${goto "..x[6].."}${color "..color2[conf_num].."}${memmax}"
  
  str = str .. "${goto "..x[7].."}${color "..color1[conf_num].."}Processeur:"
  str = str .. "${goto "..x[8].."}${color "..color2[conf_num].."}"..cpu_temp.."°C"
  
  str = str .. "${goto "..x[9].."}${color "..color1[conf_num].."}Disque 1:"
  str = str .. "${goto "..x[10].."}${color "..color2[conf_num].."}${fs_size "..mnt_point[1].."}"
  
  str = str .. "${goto "..x[11].."}${color "..color1[conf_num].."}Disque 2:"
  str = str .. "${goto "..x[12].."}${color "..color2[conf_num].."}${fs_size "..mnt_point[2].."}"
  
  str = str .. "${goto "..x[13].."}${color "..color1[conf_num].."}Download:"
  str = str .. "${goto "..x[14].."}${color "..color2[conf_num].."}${downspeed "..net_dev.."}"
  
  ------------------------------------
  str = str .. "${voffset 14}"
  
  str = str .. "${goto "..x[1].."}${font "..font0.."}${color "..color1[conf_num].."}Kernel:"
  str = str .. "${goto "..x[2].."}${color "..color2[conf_num].."}${kernel}"
  
  str = str .. "${goto "..x[3].."}${color "..color1[conf_num].."}CPU Coeur 2:"
  str = str .. "${goto "..x[4].."}${color "..color2[conf_num].."}${cpu cpu2}%"
  
  str = str .. "${goto "..x[5].."}${color "..color1[conf_num].."}RAM Free:"
  str = str .. "${goto "..x[6].."}${color "..color2[conf_num].."}${memeasyfree}"
  
  str = str .. "${goto "..x[7].."}${color "..color1[conf_num].."}Carte mère:"
  str = str .. "${goto "..x[8].."}${color "..color2[conf_num].."}"..mb_temp.."°C"
  
  str = str .. "${goto "..x[9].."}${color "..color1[conf_num].."}Espace libre:"
  str = str .. "${goto "..x[10].."}${color "..color2[conf_num].."}${fs_free "..mnt_point[1].."}"
  
  str = str .. "${goto "..x[11].."}${color "..color1[conf_num].."}Espace libre:"
  str = str .. "${goto "..x[12].."}${color "..color2[conf_num].."}${fs_free "..mnt_point[2].."}"
  
  str = str .. "${goto "..x[13].."}${color "..color1[conf_num].."}Upload:"
  str = str .. "${goto "..x[14].."}${color "..color2[conf_num].."}${upspeed "..net_dev.."}"
  
  ------------------------------------
  
  str = str .. "${voffset 7}${font "..font1.."}${color "..color0[conf_num].."}"
  
  for i, h in pairs(headers) do
    str = str .. "${goto ".. h.x .."}" .. h.txt
  end
  
  -------------------------------------
  
  str = str .. "${voffset 7}"
  
  str = str .. "${goto "..x[1].."}${font "..font0.."}${color "..color1[conf_num].."}i7 M640 2.80ghz:"
  str = str .. "${goto "..x[2].."}${color "..color2[conf_num].."}${freq_g}Mhz"
  
  str = str .. "${goto "..x[3].."}${color "..color1[conf_num].."}CPU Coeur 3:"
  str = str .. "${goto "..x[4].."}${color "..color2[conf_num].."}${cpu cpu3}%"
  
  str = str .. "${goto "..x[5].."}${color "..color1[conf_num].."}SWAP Total:"
  str = str .. "${goto "..x[6].."}${color "..color2[conf_num].."}${swapmax}"
  
  str = str .. "${goto "..x[7].."}${color "..color1[conf_num].."}Carte vidéo:"
  str = str .. "${goto "..x[8].."}${color "..color2[conf_num].."}"..gpu_temp.."°C"
  
  str = str .. "${voffset 1}"
  
  str = str .. "${goto "..io_x[1].."}${diskiograph "..dev[1].." 16,110 "..color0[conf_num].." "..color3[conf_num].." scale -t -l}"
  str = str .. "${goto "..io_x[2].."}${diskiograph "..dev[2].." 16,110 "..color0[conf_num].." "..color3[conf_num].." scale -t -l}"
  str = str .. "${goto "..io_x[3].."}${downspeedgraph "..net_dev.." 16,110 "..color0[conf_num].." "..color3[conf_num].." scale -t -l}"
  
  ------------------------------------
  
  str = str .. "${voffset 13}"
  
  str = str .. "${goto "..x[1].."}${font "..font0.."}${color "..color1[conf_num].."}Depuis:"
  str = str .. "${goto "..x[2].."}${color "..color2[conf_num].."}${uptime}"
  
  str = str .. "${goto "..x[3].."}${color "..color1[conf_num].."}CPU Coeur 4:"
  str = str .. "${goto "..x[4].."}${color "..color2[conf_num].."}${cpu cpu4}%"
  
  str = str .. "${goto "..x[5].."}${color "..color1[conf_num].."}SWAP Free:"
  str = str .. "${goto "..x[6].."}${color "..color2[conf_num].."}${swapfree}"
  
  str = str .. "${goto "..x[7].."}${color "..color1[conf_num].."}Disque:"
  str = str .. "${goto "..x[8].."}${color "..color2[conf_num].."}"..hdd_temp.."°C ${color}${font}"
  
  ------------------------------------  
  
  return str
end
-----------------------------------------------------------
-- initialization:
function conky_first()
  distrib_name = conky_parse('${sysname}')
  distrib_ver = conky_parse('${exec cat /etc/*release | grep "RELEASE" | awk -F\'=\' \'{print $2}\'} (${machine})')
  cpu_name = conky_parse('${exec cat /proc/cpuinfo | grep "model name" | cut -d " " -f3,4,5 | sed \'s/[()RTM]//g\' | head -1}')
  cpu_freq = conky_parse('${exec cat /proc/cpuinfo | grep "model name" | awk -F "@ " \'{print $2}\' | head -1}')
  
  local cnt = tonumber(conky_parse('${exec df | grep -c /dev/sd }'))
  
  for i=1, cnt do
    local str = conky_parse('${exec df | grep /dev/sd | awk \'(NR == ' .. i .. ')\' | awk \'{print $1" "$6}\' }')
    
    local dev_str = fGetWord(str, 1)
    local mnt_str = fGetWord(str, 2)   
    
    for k=1, #mnt_point do
      if mnt_point[k] == mnt_str then dev[k] = dev_str end
    end    
  end  
end
-----------------------------------------------------------
