--[[
Clock Rings by londonali1010 (2009) mise à jour (08/11/2020 par toulibre)

Ce script dessine des pourcentages sous forme d'anneaux et dessine également des aiguilles d'horloge si vous le souhaitez! Il est entièrement personnalisable; toutes les options sont décrites dans le script. Ce script est basé sur une combinaison de mon script clock.lua et de mon script rings.lua.

IMPORTANT: si vous utilisez la fonction 'cpu', cela provoquera un défaut de segmentation s'il essaie de dessiner un anneau tout de suite. L'instruction if vers la fin du script utilise un délai pour s'assurer que cela ne se produit pas. Il calcule la longueur du délai par le nombre de mises à jour depuis le démarrage de Conky. En général, une valeur de 5s est assez longue, donc si vous mettez à jour Conky toutes les 1s, utilisez update_num> 5 dans cette instruction if (par défaut). Si vous ne mettez à jour Conky que toutes les 2 secondes, vous devez le changer en update_num> 3; inversement si vous mettez à jour Conky toutes les 0,5s, vous devez utiliser update_num> 10. AUSSI, si vous changez votre Conky, est-il préférable d'utiliser "killall conky; conky" pour le mettre à jour, sinon le update_num ne sera pas réinitialisé et vous obtiendrez une erreur.

Pour appeler ce script dans Conky, utilisez ce qui suit (en supposant que vous enregistrez ce script dans ~ / scripts / rings.lua):
	lua_load ~/scripts/clock_rings-v1.1.1.lua
	lua_draw_hook_pre clock_rings

Changelog:
+ v.2 -- mise à jour le 8/11/2020 par toulibre
+ v1.1.1 -- Fixed minor bug that caused the script to crash if conky_parse() returns a nil value (20.10.2009)
+ v1.1 -- Added colour option for clock hands (07.10.2009)
+ v1.0 -- Original release (30.09.2009)
]]

settings_table = {
	--[[{
		-- Modifiez ce tableau pour personnaliser vos anneaux.
		-- Vous pouvez créer plus d'anneaux simplement en ajoutant plus d'éléments à settings_table.
		-- "name" est le type de statistique à afficher; vous pouvez choisir 'cpu', 'memperc', 'fs_used_perc', 'battery_used_perc'.
		name='time',
		-- "arg" est l'argument du type statistique, par exemple dans Conky vous écririez ${cpu cpu0}, 'cpu0' ce serait l'argument. Si vous n'utilisez pas d'argument dans la variable Conky, utilisez ''.
		arg='%I.%M',
		-- "max" est la valeur maximale de l'anneau. Si la variable Conky génère un pourcentage, utilisez 100.
		max=12,
		-- "bg_colour" est la couleur de base de l'anneau.
		bg_colour=0xffffff,
		-- "bg_alpha" est la valeur alpha de l'anneau de base.
		bg_alpha=0.0,
		-- "fg_colour" est la couleur de la partie indicatrice de l'anneau.
		fg_colour=0x86eeff,
		-- "fg_alpha" est la valeur alpha de la partie indicatrice de l'anneau.
		fg_alpha=0.0,
		-- "x" et "y" sont les coordonnées x et y du centre de l'anneau, par rapport au coin supérieur gauche de la fenêtre Conky.
		x=67, y=61,
		-- "radius" est le rayon de l'anneau.
		radius=30,
		-- "thickness" est l'épaisseur de l'anneau, centrée autour du rayon.
		thickness=2,
		-- "start_angle" est l'angle de départ de l'anneau, en degrés, dans le sens des aiguilles d'une montre à partir du haut. La valeur peut être positive ou négative.
		start_angle=0,
		-- "end_angle" est l'angle de fin de l'anneau, en degrés, dans le sens des aiguilles d'une montre à partir du haut. La valeur peut être positive ou négative, mais doit être plus grande (par exemple plus dans le sens des aiguilles d'une montre) que start_angle.
		end_angle=360
	},
	{
		name='time',
		arg='%M.%S',
		max=60,
		bg_colour=0xffffff,
		bg_alpha=0,
		fg_colour=0xffffff,
		fg_alpha=0,
		x=160, y=155,
		radius=56,
		thickness=5,
		start_angle=0,
		end_angle=360
	}, -- ]]
	{
		name='time',
		arg='%S',
		max=60,
		bg_colour=0xffffff,
		bg_alpha=0.1,
		fg_colour=0xffffff,
		fg_alpha=0.6,
		x=160, y=155,
		radius=65,
		thickness=4,
		start_angle=0,
		end_angle=360
	},
	{
		name='cpu',
		arg='cpu1',
		max=100,
		bg_colour=0xffffff,
		bg_alpha=0.2,
		fg_colour=0xffffff,
		fg_alpha=0.5,
		x=160, y=155,
		radius=75,
		thickness=5,
		start_angle=93,
		end_angle=208
	},
	{
		name='cpu',
		arg='cpu2',
		max=100,
		bg_colour=0xffffff,
		bg_alpha=0.2,
		fg_colour=0xffffff,
		fg_alpha=0.5,
		x=160, y=155,
		radius=81,
		thickness=5,
		start_angle=93,
		end_angle=208
	},

	{
                name='cpu',
                arg='cpu3',
                max=100,
                bg_colour=0xffffff,
                bg_alpha=0.2,
                fg_colour=0xffffff,
                fg_alpha=0.5,
                x=160, y=155,
                radius=87,
                thickness=5,
                start_angle=93,
                end_angle=208
        },

	{
                name='cpu',
                arg='cpu4',
                max=100,
                bg_colour=0xffffff,
                bg_alpha=0.2,
                fg_colour=0xffffff,
                fg_alpha=0.5,
                x=160, y=155,
                radius=93,
                thickness=5,
                start_angle=93,
                end_angle=208
        },
	{
		name='memperc',
		arg='',
		max=100,
		bg_colour=0xffffff,
		bg_alpha=0.2,
		fg_colour=0xffffff,
		fg_alpha=0.5,
		x=160, y=155,
		radius=84,
		thickness=22.5,
		start_angle=212,
		end_angle=329
	},
	{
		name='battery_percent',
		arg='BAT0',
		max=100,
		bg_colour=0xffffff,
		bg_alpha=0.2,
		fg_colour=0xffffff,
		fg_alpha=0.5,
		x=160, y=155,
		radius=84,
		thickness=22.5,
		start_angle=-27,
		end_angle=88
	},
	{
		name='cpu', -- dummy (used for arc)
		arg='',
		max=1,
		bg_colour=0xd5dcde,
		bg_alpha=0.7,
		fg_colour=0xd5dcde,
		fg_alpha=0,
		x=162, y=155,
		radius=118,
		thickness=2,
		start_angle=75,
		end_angle=105
	},
	{
		name='cpu', -- dummy (used for arc)
		arg='',
		max=1,
		bg_colour=0xffffff,
		bg_alpha=0.7,
		fg_colour=0xffffff,
		fg_alpha=0,
		x=266, y=155,
		radius=308,
		thickness=2,
		start_angle=84,
		end_angle=96
	},
	{
		name='fs_used_perc',
		arg='/',
		max=100,
		bg_colour=0xffffff,
		bg_alpha=0.2,
		fg_colour=0xffffff,
		fg_alpha=0.5,
		x=160, y=155,
		radius=105,
		thickness=5,
		start_angle=-120,
		end_angle=-1.5
	},
	{
		name='fs_used_perc',
		arg='/home',
		max=100,
		bg_colour=0xffffff,
		bg_alpha=0.2,
		fg_colour=0xffffff,
		fg_alpha=0.5,
		x=160, y=155,
		radius=105,
		thickness=5,
		start_angle=1.5,
		end_angle=120
	},
}

-- Use these settings to define the origin and extent of your clock.

clock_r=65

-- "clock_x" and "clock_y" are the coordinates of the centre of the clock, in pixels, from the top left of the Conky window.

clock_x=160
clock_y=155

-- Colour & alpha of the clock hands

clock_colour=0xffaa11
clock_alpha=0.4

-- Do you want to show the seconds hand?

show_seconds=false

require 'cairo'

function rgb_to_r_g_b(colour,alpha)
	return ((colour / 0x10000) % 0x100) / 255., ((colour / 0x100) % 0x100) / 255., (colour % 0x100) / 255., alpha
end

function draw_ring(cr,t,pt)
	local w,h=conky_window.width,conky_window.height

	local xc,yc,ring_r,ring_w,sa,ea=pt['x'],pt['y'],pt['radius'],pt['thickness'],pt['start_angle'],pt['end_angle']
	local bgc, bga, fgc, fga=pt['bg_colour'], pt['bg_alpha'], pt['fg_colour'], pt['fg_alpha']

	local angle_0=sa*(2*math.pi/360)-math.pi/2
	local angle_f=ea*(2*math.pi/360)-math.pi/2
	local t_arc=t*(angle_f-angle_0)

	-- Draw background ring

	cairo_arc(cr,xc,yc,ring_r,angle_0,angle_f)
	cairo_set_source_rgba(cr,rgb_to_r_g_b(bgc,bga))
	cairo_set_line_width(cr,ring_w)
	cairo_stroke(cr)

	-- Draw indicator ring

	cairo_arc(cr,xc,yc,ring_r,angle_0,angle_0+t_arc)
	cairo_set_source_rgba(cr,rgb_to_r_g_b(fgc,fga))
	cairo_stroke(cr)
end

function draw_clock_hands(cr,xc,yc)
	local secs,mins,hours,secs_arc,mins_arc,hours_arc
	local xh,yh,xm,ym,xs,ys

	secs=os.date("%S")
	mins=os.date("%M")
	hours=os.date("%I")

	secs_arc=(2*math.pi/60)*secs
	mins_arc=(2*math.pi/60)*mins+secs_arc/60
	hours_arc=(2*math.pi/12)*hours+mins_arc/12

	-- Draw hour hand

	xh=xc+0.7*clock_r*math.sin(hours_arc)
	yh=yc-0.7*clock_r*math.cos(hours_arc)
	cairo_move_to(cr,xc,yc)
	cairo_line_to(cr,xh,yh)

	cairo_set_line_cap(cr,CAIRO_LINE_CAP_ROUND)
	cairo_set_line_width(cr,5)
	cairo_set_source_rgba(cr,rgb_to_r_g_b(clock_colour,clock_alpha))
	cairo_stroke(cr)

	-- Draw minute hand

	xm=xc+clock_r*math.sin(mins_arc)
	ym=yc-clock_r*math.cos(mins_arc)
	cairo_move_to(cr,xc,yc)
	cairo_line_to(cr,xm,ym)

	cairo_set_line_width(cr,3)
	cairo_stroke(cr)

	-- Draw seconds hand

	if show_seconds then
		xs=xc+clock_r*math.sin(secs_arc)
		ys=yc-clock_r*math.cos(secs_arc)
		cairo_move_to(cr,xc,yc)
		cairo_line_to(cr,xs,ys)

		cairo_set_line_width(cr,1)
		cairo_stroke(cr)
	end
end

function conky_clock_rings()
	local function setup_rings(cr,pt)
                local str=''
                local value=0

                str=string.format('${%s %s}',pt['name'],pt['arg'])
                str=conky_parse(str)

                value=tonumber(str)
                if value == nil then value = 0 end
                pct=value/pt['max']

                draw_ring(cr,pct,pt)
        end



	-- Check that Conky has been running for at least 5s

	if conky_window==nil then return end
	local cs=cairo_xlib_surface_create(conky_window.display,conky_window.drawable,conky_window.visual, conky_window.width,conky_window.height)

	local cr=cairo_create(cs)	

	local updates=conky_parse('${updates}')
	update_num=tonumber(updates)

	if update_num>5 then
		for i in pairs(settings_table) do
			setup_rings(cr,settings_table[i])
		end
	end

	draw_clock_hands(cr,clock_x,clock_y)
end
